// // // // // // // // // // // // // // // //
//
//	Enemy Territory - Communicator.h
//
//	erstellt 1.2.98 Andreas Warnke
//	geändert 15.4.98 von Andreas Warnke
//



#ifndef Communicator_h_
#define Communicator_h_



// // // // // // // // // // // // // // // //
//
//	include:
//

#include "ZeitWelt.h"
#include "Spieler.h"
#include "FateMaker.h"



// // // // // // // // // // // // // // // //
//
//	Communicator
//

class Communicator : public ZeitWelt
{
private:
	void AddObjectsToMessage (
		int inX,
		int inY,
		bool inCompleteSensorData,
		BMessage* inMsg );
	
protected:
	void GetAllVisibleFields (
		int inX,
		int inY,
		int* outX,	//	Feld mit 37 Elementen
		int* outY,	//	Feld mit 37 Elementen
		unsigned int & outCount );
	
public:
	//	Infos über die Spieler:
	ElementList SpielerListe;
	
public:
	//	Konstruktor:
	Communicator ( unsigned int inMapSize );
	
	//	Destruktor:
	virtual ~Communicator ();
	
	//	Informiere Clients über Änderung
	void ReportChangedField (
		int inChangeX,
		int inChangeY,
		unsigned int inIgnoreID = 0 );
	void ReportMove (
		int inFromX,
		int inFromY,
		int inToX,
		int inToY,
		unsigned int inID );
	void ReportEverything ( Spieler * inNeuerSpieler );
	
	//	Informiere Clients über Sieg
	void ReportVictory (
		unsigned int inID,
		const char * inName );
};



#endif



//
//	Ende
//
// // // // // // // // // // // // // // // //